# WorldTime Subtitle Adjuster - Feature List

A running checklist of features for the WorldTime-based subtitle time adjustment tool.  
Edit this file as development progresses. Mark completed items with `[x]`.  
Upload this file before starting a new coding round.

---

## 1. Core Functions
- [ ] Open video file (MP4, MOV, etc.)
- [ ] Open `.srt` subtitle file
- [ ] Extract video frame timestamps
- [ ] Convert frame numbers ↔ real-world times (RTC)
- [ ] Adjust `.srt` times based on offset between video clock and real-world clock
- [ ] Save new subtitle file with suffix (e.g. `_RTC.srt`)

---

## 2. File Handling
- [ ] Default output name (`_RTC.srt`)
- [ ] Remember last opened video file
- [ ] Remember last opened subtitle file
- [ ] Let user change output folder and file name
- [ ] Ask before overwriting if output exists

---

## 3. GUI
- [ ] Tkinter-based interface
- [ ] File browser for video
- [ ] File browser for subtitle
- [ ] Drop-down or drag-and-drop support
- [ ] Numeric entry for frame number → calculate offset
- [ ] Show calculated offset in hh:mm:ss.sss
- [ ] Button to apply shift and save adjusted `.srt`

---

## 4. Advanced Features (Future Ideas)
- [ ] Auto-detect video time overlay (OCR on clock digits)
- [ ] Sync with external flight log timestamps
- [ ] Batch adjust multiple subtitle files with same offset
- [ ] Timeline/graph view of offset drift
- [ ] Preview adjusted subtitles on video

---

## Notes
- Store user preferences (last file paths, last offsets) in JSON config
- Stick to common Python libraries (`tkinter`, `pysrt`, `opencv-python` for frame extraction if needed)
- Keep code modular so GUI and logic can be reused in other tools
